function [deltaY, deltaX] = PIV_subpixelpeak(I)

%
% PIV_subpixelpeak - Find the subpixel position of a correlation peak
% (This function is called by the function PIV)
%

I = log(I);

deltaY = real((I(1,2)-I(3,2))/(2*I(1,2)-4*I(2,2)+2*I(3,2)));

deltaX = real((I(2,1)-I(2,3))/(2*I(2,1)-4*I(2,2)+2*I(2,3)));