function PIVgui_Conversion(main_handle)
% PIVgui Brief description of GUI.
%        Comments displayed at the command line in response
%        to the help command.

% (Leave a blank line following the help.)

%%  Initialization tasks

figureHeight = 300;

fh = figure(...
    'MenuBar','none',...
    'Toolbar','none',...
    'Position',[10 10 300 figureHeight],...
    'Color',[0.94 0.94 0.94],...
    'NumberTitle','off',...
    'Name','Data conversion',...
    'Visible','off',...
    'WindowStyle','modal');
movegui(fh,'center')
set(fh,'CloseRequestFcn',@CancelCallback)

% load data
PIVParams = guidata(main_handle);

%%  Construct the components
vPos = figureHeight-50;
vSpacing = 40;
hPos = 20;
hSpacing = 180;
textWidth = 170;
editWidth = 80;
controlHeight = 25;
uicontrol(fh,'Style','text',...
    'String','Framerate (fps):',...
    'HorizontalAlignment','Left',...
    'Position',[hPos vPos-5 textWidth controlHeight]);
FPS = uicontrol(fh,'Style','edit',...
    'String',num2str(PIVParams.FPS),...
    'Position',[hPos+hSpacing vPos editWidth controlHeight]);
vPos = vPos - vSpacing;
uicontrol(fh,'Style','text',...
    'String','Image scale (length-units/pixel):',...
    'HorizontalAlignment','Left',...
    'Position',[hPos vPos-5 textWidth controlHeight]);
Scaling = uicontrol(fh,'Style','edit',...
    'String',num2str(PIVParams.Scaling),...
    'Position',[hPos+hSpacing vPos editWidth controlHeight]);
vPos = vPos - vSpacing;
uicontrol(fh,'Style','text',...
    'String','Time unit:',...
    'HorizontalAlignment','Left',...
    'Position',[hPos vPos-5 textWidth controlHeight]);
TimeUnit = uicontrol(fh,'Style','edit',...
    'String',PIVParams.TimeUnit,...
    'Position',[hPos+hSpacing vPos editWidth controlHeight]);
vPos = vPos - vSpacing;
uicontrol(fh,'Style','text',...
    'String','Length unit:',...
    'HorizontalAlignment','Left',...
    'Position',[hPos vPos-5 textWidth controlHeight]);
LengthUnit = uicontrol(fh,'Style','edit',...
    'String',PIVParams.LengthUnit,...
    'Position',[hPos+hSpacing vPos editWidth controlHeight]);
vPos = vPos - vSpacing;
uicontrol(fh,'Style','text',...
    'String','Velocity unit:',...
    'HorizontalAlignment','Left',...
    'Position',[hPos vPos-5 textWidth controlHeight]);
VelocityUnit = uicontrol(fh,'Style','edit',...
    'String',PIVParams.VelocityUnit,...
    'Position',[hPos+hSpacing vPos editWidth controlHeight]);


%%% OK and cancel
uicontrol(fh,'Style','pushbutton',...
    'String','OK',...
    'Position',[30 30 110 30],...
    'Callback',@ApplyCallback);
uicontrol(fh,'Style','pushbutton',...
    'String','Cancel',...
    'Position',[170 30 110 30],...
    'Callback',@CancelCallback);

%%  Initialization tasks

set(fh,'Visible','on')

%%  Callbacks
    function CancelCallback(~,~)
        delete(fh)
    end
    function ApplyCallback(~,~)
        % load the structure
        PIVParams = guidata(main_handle);

        %%% adjust the data
        PIVParams.FPS = str2double(get(FPS,'String'));
        PIVParams.Scaling = str2double(get(Scaling,'String'));
        PIVParams.TimeUnit = get(TimeUnit,'String');
        PIVParams.LengthUnit = get(LengthUnit,'String');
        PIVParams.VelocityUnit = get(VelocityUnit,'String');
        
        %%% save the structure
        guidata(main_handle,PIVParams)
        delete(fh)
    end

%%  Utility functions

end