function PIVgui_Correlation(main_handle)
% PIVgui Brief description of GUI.
%        Comments displayed at the command line in response
%        to the help command.

% (Leave a blank line following the help.)

%%  Initialization tasks

figureHeight = 300;

fh = figure(...
    'MenuBar','none',...
    'Toolbar','none',...
    'Position',[10 10 300 figureHeight],...
    'Color',[0.94 0.94 0.94],...
    'NumberTitle','off',...
    'Name','Correlation settings',...
    'Visible','off',...
    'WindowStyle','modal');
movegui(fh,'center')
set(fh,'CloseRequestFcn',@CancelCallback)

% make some content:
InitialGridSizeString = {'256','224','192','160','128','96','64','32'};
InitialGridSizeValues = uint16(str2double(InitialGridSizeString));

% load data
PIVParams = guidata(main_handle);

%%  Construct the components
vPos = figureHeight-50;
vSpacing = 40;
hPos = 30;
controlHeight = 25;
uicontrol(fh,'Style','text',...
    'String','Correlation method:',...
    'Position',[hPos-20 vPos-5 100 controlHeight]);
switch PIVParams.Method
    case 'XCORR'
        Value = 1;
    case 'NORMXCORR'
        Value = 2;
end
Method = uicontrol(fh,'Style','popupmenu',...
    'String',{'xcorr','normxcorr'},...
    'Value',Value,...
    'Position',[hPos+90 vPos 100 controlHeight]);

vPos = vPos - vSpacing;
uicontrol(fh,'Style','text',...
    'String','Number of passes:',...
    'HorizontalAlignment','Left',...
    'Position',[hPos-20 vPos-5 100 controlHeight]);
NumPasses = uicontrol(fh,'Style','edit',...
    'String',num2str(PIVParams.NumPasses),...
    'Position',[hPos+90 vPos 50 controlHeight]);

vPos = vPos - vSpacing;
UseGridRefinement = uicontrol(fh,'Style','checkbox',...
    'String','Use grid refinement',...
    'Value',PIVParams.UseGridRefinement,...
    'Position',[hPos vPos 200 controlHeight]);

vPos = vPos - vSpacing;
uicontrol(fh,'Style','text',...
    'String','Initial grid size for grid refinement:',...
    'HorizontalAlignment','Left',...
    'Position',[hPos-20 vPos-5 100 controlHeight]);
InitialGridSize = uicontrol(fh,'Style','popupmenu',...
    'String',InitialGridSizeString,...
    'Value',find(InitialGridSizeValues==PIVParams.InitialGridSize),...
    'Position',[hPos+90 vPos 80 controlHeight]);

vPos = vPos - vSpacing;
uicontrol(fh,'Style','text',...
    'String','Correlation step:',...
    'HorizontalAlignment','Left',...
    'Position',[hPos-20 vPos-5 100 controlHeight]);
CorrelationStep = uicontrol(fh,'Style','edit',...
    'String',num2str(PIVParams.CorrelationStep),...
    'Position',[hPos+90 vPos 50 controlHeight]);

%%% OK and cancel
uicontrol(fh,'Style','pushbutton',...
    'String','OK',...
    'Position',[30 30 110 30],...
    'Callback',@ApplyCallback);
uicontrol(fh,'Style','pushbutton',...
    'String','Cancel',...
    'Position',[170 30 110 30],...
    'Callback',@CancelCallback);

%%  Initialization tasks

set(fh,'Visible','on')

%%  Callbacks
    function CancelCallback(~,~)
        delete(fh)
    end
    function ApplyCallback(~,~)
        % load the structure
        PIVParams = guidata(main_handle);

        %%% adjust the data
        switch get(Method,'Value');
            case 1
                PIVParams.Method = 'XCORR';
            case 2
                PIVParams.Method = 'NORMXCORR';
        end
        PIVParams.NumPasses = uint16(str2double(get(NumPasses,'String')));
        PIVParams.UseGridRefinement = get(UseGridRefinement,'Value');
        PIVParams.InitialGridSize = InitialGridSizeValues(get(InitialGridSize,'Value'));
        PIVParams.CorrelationStep = uint16(str2double(get(CorrelationStep,'String')));
        
        %%% save the structure
        guidata(main_handle,PIVParams)
        delete(fh)
    end

%%  Utility functions

end