function PIVgui_FileLocations(main_handle)
% PIVgui Brief description of GUI.
%        Comments displayed at the command line in response
%        to the help command.

% (Leave a blank line following the help.)

%%  Initialization tasks

figureHeight = 500;

fh = figure(...
    'MenuBar','none',...
    'Toolbar','none',...
    'Position',[10 10 450 figureHeight],...
    'Color',[0.94 0.94 0.94],...
    'NumberTitle','off',...
    'Name','File locations',...
    'Visible','off',...
    'WindowStyle','modal');
movegui(fh,'center')
set(fh,'CloseRequestFcn',@CancelCallback)

% load data
PIVParams = guidata(main_handle);

%%  Construct the components
vPos = figureHeight-50;
vSpacing = 40;
hPos = 20;
hSpacing = 200;
textWidth = hSpacing-10;
editWidth = 80;
controlHeight = 25;
uicontrol(fh,'Style','text',...
    'String','Image filename prefix (optional):',...
    'HorizontalAlignment','Left',...
    'Position',[hPos vPos-5 textWidth controlHeight]);
ImageFileName = uicontrol(fh,'Style','edit',...
    'String',PIVParams.ImageFileName,...
    'Position',[hPos+hSpacing vPos editWidth controlHeight]);
uicontrol(fh,'Style','pushbutton',...
    'String','Select image ...',...
    'Position',[hPos+hSpacing+editWidth+20 vPos 110 controlHeight],...
    'Callback',@SelectImageFile);
vPos = vPos - vSpacing;
uicontrol(fh,'Style','text',...
    'String','Image filename extension:',...
    'HorizontalAlignment','Left',...
    'Position',[hPos vPos-5 textWidth controlHeight]);
FileExtension = uicontrol(fh,'Style','edit',...
    'String',PIVParams.FileExtension,...
    'Position',[hPos+hSpacing vPos editWidth controlHeight]);
vPos = vPos - vSpacing;
MultipageTiff = uicontrol(fh,'Style','checkbox',...
    'String','Image is a multipage tiff',...
    'Value',PIVParams.MultipageTiff,...
    'Position',[hPos vPos 200 controlHeight]);
vPos = vPos - vSpacing;
uicontrol(fh,'Style','text',...
    'String','Path of input images:',...
    'HorizontalAlignment','Left',...
    'Position',[hPos vPos-5 textWidth controlHeight]);
Directory = uicontrol(fh,'Style','edit',...
    'String',PIVParams.Directory,...
    'Position',[hPos+hSpacing vPos editWidth controlHeight]);
vPos = vPos - vSpacing;
uicontrol(fh,'Style','text',...
    'String','First image:',...
    'HorizontalAlignment','Left',...
    'Position',[hPos vPos-5 textWidth controlHeight]);
FirstImage = uicontrol(fh,'Style','edit',...
    'String',PIVParams.FirstImage,...
    'Position',[hPos+hSpacing vPos editWidth controlHeight]);
vPos = vPos - vSpacing;
uicontrol(fh,'Style','text',...
    'String','Last Image:',...
    'HorizontalAlignment','Left',...
    'Position',[hPos vPos-5 textWidth controlHeight]);
LastImage = uicontrol(fh,'Style','edit',...
    'String',PIVParams.LastImage,...
    'Position',[hPos+hSpacing vPos editWidth controlHeight]);
vPos = vPos - vSpacing;
uicontrol(fh,'Style','text',...
    'String','Skip images:',...
    'HorizontalAlignment','Left',...
    'Position',[hPos vPos-5 textWidth controlHeight]);
SkipImages = uicontrol(fh,'Style','edit',...
    'String',PIVParams.SkipImages,...
    'Position',[hPos+hSpacing vPos editWidth controlHeight]);
vPos = vPos - vSpacing;
uicontrol(fh,'Style','text',...
    'String','Image output directory:',...
    'HorizontalAlignment','Left',...
    'Position',[hPos vPos-5 textWidth controlHeight]);
ImageOutputDir = uicontrol(fh,'Style','edit',...
    'String',PIVParams.ImageOutputDir,...
    'Position',[hPos+hSpacing vPos editWidth controlHeight]);
uicontrol(fh,'Style','pushbutton',...
    'String','Browse ...',...
    'Position',[hPos+hSpacing+editWidth+20 vPos 110 controlHeight],...
    'Callback',@SelectImageOutputDir);
vPos = vPos - vSpacing;
uicontrol(fh,'Style','text',...
    'String','Data input/output directory:',...
    'HorizontalAlignment','Left',...
    'Position',[hPos vPos-5 textWidth controlHeight]);
DataDir = uicontrol(fh,'Style','edit',...
    'String',PIVParams.DataDir,...
    'Position',[hPos+hSpacing vPos editWidth controlHeight]);
uicontrol(fh,'Style','pushbutton',...
    'String','Browse ...',...
    'Position',[hPos+hSpacing+editWidth+20 vPos 110 controlHeight],...
    'Callback',@SelectDataDir);





%%% OK and cancel
uicontrol(fh,'Style','pushbutton',...
    'String','OK',...
    'Position',[30 30 110 30],...
    'Callback',@ApplyCallback);
uicontrol(fh,'Style','pushbutton',...
    'String','Cancel',...
    'Position',[170 30 110 30],...
    'Callback',@CancelCallback);

%%  Initialization tasks

set(fh,'Visible','on')

%%  Callbacks
    function SelectImageFile(~,~)
        % open ui to select a file
        [FileName,PathName,~] = uigetfile([PIVParams.Directory '*.*']);
        if ischar(FileName)
            % get file info
            info = imfinfo([PathName FileName]);
            % determine the extension of the file (everything after the last '.')
            index = find(FileName=='.',1,'last');
            extension = FileName(index+1:end);
            set(FileExtension,'String',extension);
            % determine the prefix (the filename until the last letter
            % character excluding the extension)
            FileName = FileName(1:index-1);
            index = find(isletter(FileName),1,'last');
            prefix = FileName(1:index);
            set(ImageFileName,'String',prefix);
            % set the directory
            set(Directory,'String',PathName);
            % determine if there is more than one image in the file
            if length(info)>1
                set(MultipageTiff,'Value',1)
                TotalImages = length(info);
            else
                set(MultipageTiff,'Value',0)
                % determine number of files
                fileList = dir([PathName prefix '*.' extension]);
                TotalImages = length(fileList);
            end
            % set the image range to include all images
            set(FirstImage,'String','1')
            set(LastImage,'String',num2str(TotalImages-1))
            set(SkipImages,'String','0')
        end
    end
    function SelectImageOutputDir(~,~)
        folder_name = uigetdir(PIVParams.ImageOutputDir, 'Select image output directory');
        set(ImageOutputDir,'String',folder_name);
    end
    function SelectDataDir(~,~)
        folder_name = uigetdir(PIVParams.DataDir, 'Select data input/output directory');
        set(DataDir,'String',folder_name);
    end
    function CancelCallback(~,~)
        delete(fh)
    end
    function ApplyCallback(~,~)
        % load the structure
        PIVParams = guidata(main_handle);
        
        %%% adjust the data
        PIVParams.ImageFileName = get(ImageFileName,'String');
        PIVParams.FileExtension = get(FileExtension,'String');
        PIVParams.MultipageTiff = get(MultipageTiff,'Value');
        if ismac || isunix
            dirSpacer = '/';
        else
            dirSpacer = '\';
        end
        dirString = get(Directory,'String');
        if dirString(end)==dirSpacer
            PIVParams.Directory = dirString;
        else
            PIVParams.Directory = [dirString dirSpacer];
        end
        PIVParams.ImageOutputDir = get(ImageOutputDir,'String');
        PIVParams.DataDir = get(DataDir,'String');
        PIVParams.FirstImage = uint64(str2double(get(FirstImage,'String')));
        PIVParams.LastImage = uint64(str2double(get(LastImage,'String')));
        PIVParams.SkipImages = uint64(str2double(get(SkipImages,'String')));
        
        
        %%% save the structure
        guidata(main_handle,PIVParams)
        %figure(main_handle)
        delete(fh)
    end

%%  Utility functions

end