function PIVgui_ImagePreprocess(main_handle)
% PIVgui Brief description of GUI.
%        Comments displayed at the command line in response
%        to the help command.

% (Leave a blank line following the help.)

%%  Initialization tasks

figureHeight = 350;

fh = figure(...
    'MenuBar','none',...
    'Toolbar','none',...
    'Position',[10 10 300 figureHeight],...
    'Color',[0.94 0.94 0.94],...
    'NumberTitle','off',...
    'Name','Image preprocessing',...
    'Visible','off',...
    'WindowStyle','modal');
movegui(fh,'center')
set(fh,'CloseRequestFcn',@CancelCallback)

% load data
PIVParams = guidata(main_handle);

%%  Construct the components
vPos = figureHeight-50;
vSpacing = 40;
hPos = 20;
hSpacing = 170;
textWidth = hSpacing-10;
editWidth = 80;
controlHeight = 25;

UseMinMax = uicontrol(fh,'Style','checkbox',...
    'String','Use MinMax filter',...
    'Value',PIVParams.UseMinMax,...
    'Position',[hPos+10 vPos 200 controlHeight]);
vPos = vPos - vSpacing;
uicontrol(fh,'Style','text',...
    'String','MinMax kernel size (pixels):',...
    'HorizontalAlignment','Left',...
    'Position',[hPos vPos-5 textWidth controlHeight]);
MinMaxKernel = uicontrol(fh,'Style','edit',...
    'String',num2str(PIVParams.MinMaxKernel),...
    'Position',[hPos+hSpacing vPos editWidth controlHeight]);
vPos = vPos - vSpacing;
UseUnsharpMask = uicontrol(fh,'Style','checkbox',...
    'String','Sharpen image (unsharp mask)',...
    'Value',PIVParams.UseUnsharpMask,...
    'Position',[hPos+10 vPos 200 controlHeight]);
vPos = vPos - vSpacing;
uicontrol(fh,'Style','text',...
    'String','Unsharp mask amount:',...
    'HorizontalAlignment','Left',...
    'Position',[hPos vPos-5 textWidth controlHeight]);
UnsharpMaskAmount = uicontrol(fh,'Style','edit',...
    'String',num2str(PIVParams.UnsharpMaskAmount),...
    'Position',[hPos+hSpacing vPos editWidth controlHeight]);
vPos = vPos - vSpacing;
UseGaussianBlur = uicontrol(fh,'Style','checkbox',...
    'String','Apply gaussian blur',...
    'Value',PIVParams.UseGaussianBlur,...
    'Position',[hPos+10 vPos 200 controlHeight]);
vPos = vPos - vSpacing;
uicontrol(fh,'Style','text',...
    'String','Gaussian blur radius (pixels):',...
    'HorizontalAlignment','Left',...
    'Position',[hPos vPos-5 textWidth controlHeight]);
GaussianBlurRadius = uicontrol(fh,'Style','edit',...
    'String',num2str(PIVParams.GaussianBlurRadius),...
    'Position',[hPos+hSpacing vPos editWidth controlHeight]);


%%% OK and cancel
uicontrol(fh,'Style','pushbutton',...
    'String','OK',...
    'Position',[30 30 110 30],...
    'Callback',@ApplyCallback);
uicontrol(fh,'Style','pushbutton',...
    'String','Cancel',...
    'Position',[170 30 110 30],...
    'Callback',@CancelCallback);

%%  Initialization tasks

set(fh,'Visible','on')

%%  Callbacks
    function CancelCallback(~,~)
        delete(fh)
    end
    function ApplyCallback(~,~)
        % load the structure
        PIVParams = guidata(main_handle);

        %%% adjust the data
        PIVParams.UseMinMax = get(UseMinMax,'Value');
        PIVParams.MinMaxKernel = uint8(str2double(get(MinMaxKernel,'String')));
        PIVParams.UseUnsharpMask = get(UseUnsharpMask,'Value');
        PIVParams.UnsharpMaskAmount = str2double(get(UnsharpMaskAmount,'String'));
        PIVParams.UseGaussianBlur = get(UseGaussianBlur,'Value');
        PIVParams.GaussianBlurRadius = str2double(get(GaussianBlurRadius,'String'));
        
        %%% save the structure
        guidata(main_handle,PIVParams)
        delete(fh)
    end

%%  Utility functions

end