function PIVgui_Validation(main_handle)
% PIVgui Brief description of GUI.
%        Comments displayed at the command line in response
%        to the help command.

% (Leave a blank line following the help.)

%%  Initialization tasks

figureHeight = 500;
figureWidth = 600;

fh = figure(...
    'MenuBar','none',...
    'Toolbar','none',...
    'Position',[10 10 figureWidth figureHeight],...
    'Color',[0.94 0.94 0.94],...
    'NumberTitle','off',...
    'Name','Validation and filtering',...
    'Visible','off',...
    'WindowStyle','modal');
movegui(fh,'center')
set(fh,'CloseRequestFcn',@CancelCallback)

% make some content:
FilterNamesString = {'gaussian','average'};

% load data
PIVParams = guidata(main_handle);

%%  Construct the components
vPos = figureHeight-50;
vSpacing = 40;
hPos = 20;
hSpacing = 200;
textWidth = hSpacing-10;
editWidth = 80;
controlHeight = 25;

%-------------------------------------------------------------------------
% Detection of spurious vectors
uicontrol(fh,'Style','text',...
    'String','Outlier detection',...
    'Position',[hPos+10 vPos textWidth controlHeight]);
vPos = vPos - vSpacing;
uicontrol(fh,'Style','text',...
    'String','Maximum number of validation passes:',...
    'HorizontalAlignment','Left',...
    'Position',[hPos vPos-5 textWidth controlHeight]);
numValidationPasses = uicontrol(fh,'Style','edit',...
    'String',num2str(PIVParams.numValidationPasses),...
    'Position',[hPos+hSpacing vPos editWidth controlHeight]);
vPos = vPos - vSpacing;
UseMaxDisplacement = uicontrol(fh,'Style','checkbox',...
    'String','Maximum displacement (pixels):',...
    'Value',PIVParams.UseMaxDisplacement,...
    'Position',[hPos+10 vPos textWidth controlHeight]);
MaxDisplacement = uicontrol(fh,'Style','edit',...
    'String',num2str(PIVParams.MaxDisplacement),...
    'Position',[hPos+hSpacing vPos editWidth controlHeight]);
vPos = vPos - vSpacing;
UseMinCorrelationCoefficient = uicontrol(fh,'Style','checkbox',...
    'String','Minimum correlation coefficient:',...
    'Value',PIVParams.UseMinCorrelationCoefficient,...
    'Position',[hPos+10 vPos 200 controlHeight]);
MinCorrelationCoefficient = uicontrol(fh,'Style','edit',...
    'String',num2str(PIVParams.MinCorrelationCoefficient),...
    'Position',[hPos+hSpacing vPos editWidth controlHeight]);
vPos = vPos - vSpacing;
UseNormalizedMedianTest = uicontrol(fh,'Style','checkbox',...
    'String','Normalized median test threshold:',...
    'Value',PIVParams.UseNormalizedMedianTest,...
    'Position',[hPos+10 vPos 200 controlHeight]);
MedianThreshold = uicontrol(fh,'Style','edit',...
    'String',num2str(PIVParams.MedianThreshold),...
    'Position',[hPos+hSpacing vPos editWidth controlHeight]);


%-------------------------------------------------------------------------
% Replacement of spurious vectors
vPos = figureHeight-50;
hPos = 400;
textWidth = 150;
uicontrol(fh,'Style','text',...
    'String','Outlier replacement',...
    'Position',[hPos+10 vPos textWidth controlHeight]);
vPos = vPos - vSpacing;
UseSecondPeak = uicontrol(fh,'Style','checkbox',...
    'String','Try second order peak',...
    'Value',PIVParams.UseSecondPeak,...
    'Position',[hPos+10 vPos textWidth controlHeight]);
vPos = vPos - vSpacing;
UseInterpolation = uicontrol(fh,'Style','checkbox',...
    'String','Interpolate data',...
    'Value',PIVParams.UseInterpolation,...
    'Position',[hPos+10 vPos textWidth controlHeight]);

%-------------------------------------------------------------------------
% Data filtering
vPos = vPos - 4*vSpacing;
hPos = 20;
uicontrol(fh,'Style','text',...
    'String','Data smoothing',...
    'Position',[hPos+10 vPos textWidth controlHeight]);
vPos = vPos - vSpacing;
UseDataSmoothing = uicontrol(fh,'Style','checkbox',...
    'String','Use smoothing filter',...
    'Value',PIVParams.UseDataSmoothing,...
    'Position',[hPos+10 vPos textWidth controlHeight]);
vPos = vPos - vSpacing;
uicontrol(fh,'Style','text',...
    'String','Smoothing filter size (pixels):',...
    'HorizontalAlignment','Left',...
    'Position',[hPos+10 vPos textWidth controlHeight]);
SmoothingFilterSize = uicontrol(fh,'Style','edit',...
    'String',num2str(PIVParams.SmoothingFilterSize),...
    'Position',[hPos+hSpacing vPos editWidth controlHeight]);
vPos = vPos - vSpacing;
uicontrol(fh,'Style','text',...
    'String','Smoothing filter type:',...
    'HorizontalAlignment','Left',...
    'Position',[hPos+10 vPos textWidth controlHeight]);
SmoothingFilterType = uicontrol(fh,'Style','popupmenu',...
    'String',FilterNamesString,...
    'Value', find(strcmp(FilterNamesString,PIVParams.SmoothingFilterType)),...
    'Position',[hPos+hSpacing vPos 100 controlHeight]);

%%% OK and cancel
uicontrol(fh,'Style','pushbutton',...
    'String','OK',...
    'Position',[30 30 110 30],...
    'Callback',@ApplyCallback);
uicontrol(fh,'Style','pushbutton',...
    'String','Cancel',...
    'Position',[170 30 110 30],...
    'Callback',@CancelCallback);

%%  Initialization tasks

set(fh,'Visible','on')

%%  Callbacks
    function CancelCallback(~,~)
        delete(fh)
    end
    function ApplyCallback(~,~)
        % load the structure
        PIVParams = guidata(main_handle);

        %%% adjust the data
        PIVParams.numValidationPasses = uint8(str2double(get(numValidationPasses,'String')));
        PIVParams.UseMaxDisplacement = get(UseMaxDisplacement,'Value');
        PIVParams.MaxDisplacement = str2double(get(MaxDisplacement,'String'));
        PIVParams.UseMinCorrelationCoefficient = get(UseMinCorrelationCoefficient,'Value');
        PIVParams.MinCorrelationCoefficient = str2double(get(MinCorrelationCoefficient,'String'));
        PIVParams.UseNormalizedMedianTest = get(UseNormalizedMedianTest,'Value');
        PIVParams.MedianThreshold = str2double(get(MedianThreshold,'String'));
        
        PIVParams.UseSecondPeak = get(UseSecondPeak,'Value');
        PIVParams.UseInterpolation = get(UseInterpolation,'Value');
        
        PIVParams.UseDataSmoothing = get(UseDataSmoothing,'Value');
        PIVParams.SmoothingFilterSize = str2double(get(SmoothingFilterSize,'String'));
        PIVParams.SmoothingFilterType = char(FilterNamesString(get(SmoothingFilterType,'Value')));
        
        
        %%% save the structure
        guidata(main_handle,PIVParams)
        delete(fh)
    end

%%  Utility functions

end