function PIVgui_Visualization(main_handle)
% PIVgui Brief description of GUI.
%        Comments displayed at the command line in response
%        to the help command.

% (Leave a blank line following the help.)

%%  Initialization tasks

figureHeight = 600;
figureWidth = 350;

fh = figure(...
    'MenuBar','none',...
    'Toolbar','none',...
    'Position',[10 10 figureWidth figureHeight],...
    'Color',[0.94 0.94 0.94],...
    'NumberTitle','off',...
    'Name','Visualization',...
    'Visible','off');%,...
%     'WindowStyle','modal');
movegui(fh,'center')
set(fh,'CloseRequestFcn',@CancelCallback)

% make some content:
Colormaps = {'PIVBlueWhiteRed','jet','hsv','hot','cool','spring','summer','autumn','winter','gray','bone','copper','pink'};
ContourScalars = {'magnitude', 'signalToNoiseRatio', 'correlationCoefficient',...
    'vorticity', 'shearStrain', 'normalStrain', 'dudx', 'dudy', 'dvdx', 'dvdy',...
    'xComponent', 'yComponent'};

% load data
PIVParams = guidata(main_handle);

%%  Construct the components
vPos = figureHeight-50;
vSpacing = 30;
hPos = 20;
hSpacing = 140;
textWidth = hSpacing-10;
controlHeight = 25;
controlWidth = 120;

ShowVectors = uicontrol(fh,'Style','checkbox',...
    'String','Show vectors',...
    'Value',PIVParams.ShowVectors,...
    'Position',[hPos+10 vPos textWidth controlHeight]);
vPos = vPos - vSpacing;
uicontrol(fh,'Style','text',...
    'String','Vector coloring:',...
    'HorizontalAlignment','Left',...
    'Position',[hPos vPos-5 textWidth controlHeight]);
if PIVParams.VectorColorValidation
    Value = 3;
else
    Value = PIVParams.ColorCodeVectors+1;
end
ColorCodeVectors = uicontrol(fh,'Style','popupmenu',...
    'String',{'Single color', 'Use colormap', 'Validation'},...
    'Value',Value,...
    'Position',[hPos+hSpacing vPos controlWidth controlHeight]);
vPos = vPos - vSpacing;
uicontrol(fh,'Style','text',...
    'String','Color map:',...
    'HorizontalAlignment','Left',...
    'Position',[hPos vPos-5 textWidth controlHeight]);
VectorColormap = uicontrol(fh,'Style','popupmenu',...
    'String',Colormaps,...
    'Value', find(strcmp(Colormaps,PIVParams.VectorColormap)),...
    'Position',[hPos+hSpacing vPos controlWidth controlHeight]);
vPos = vPos - vSpacing;
uicontrol(fh,'Style','text',...
    'String','Vector color:',...
    'HorizontalAlignment','Left',...
    'Position',[hPos vPos-5 textWidth controlHeight]);
if ischar(PIVParams.VectorColor)
    String = PIVParams.VectorColor;
else
    c = PIVParams.VectorColor;
    String = ['[' num2str(c(1)) ' ' num2str(c(2)) ' ' num2str(c(3)) ']'];
end
VectorColor = uicontrol(fh,'Style','edit',...
    'String',String,...
    'Position',[hPos+hSpacing vPos controlWidth controlHeight]);
vPos = vPos - vSpacing;
uicontrol(fh,'Style','text',...
    'String',['Vector scale (pixels/' PIVParams.VelocityUnit '):'],...
    'HorizontalAlignment','Left',...
    'Position',[hPos vPos-5 textWidth controlHeight]);
VectorScale = uicontrol(fh,'Style','edit',...
    'String',num2str(PIVParams.VectorScale),...
    'Position',[hPos+hSpacing vPos controlWidth controlHeight]);
vPos = vPos - vSpacing;
ShowImage = uicontrol(fh,'Style','checkbox',...
    'String','Show image',...
    'Value',PIVParams.ShowImage,...
    'Position',[hPos+10 vPos textWidth controlHeight]);
vPos = vPos - vSpacing;
ShowGrid = uicontrol(fh,'Style','checkbox',...
    'String','Show grid',...
    'Value',PIVParams.ShowGrid,...
    'Position',[hPos+10 vPos textWidth controlHeight]);
vPos = vPos - vSpacing;
ShowContour = uicontrol(fh,'Style','checkbox',...
    'String','Show contour',...
    'Value',PIVParams.ShowContour,...
    'Position',[hPos+10 vPos textWidth controlHeight]);
vPos = vPos - vSpacing;
uicontrol(fh,'Style','text',...
    'String','Contour type:',...
    'HorizontalAlignment','Left',...
    'Position',[hPos vPos-5 textWidth controlHeight]);
ContourScalar = uicontrol(fh,'Style','popupmenu',...
    'String',ContourScalars,...
    'Value', find(strcmp(ContourScalars,PIVParams.ContourScalar)),...
    'Position',[hPos+hSpacing vPos controlWidth controlHeight]);
vPos = vPos - vSpacing;
uicontrol(fh,'Style','text',...
    'String','Contour colormap:',...
    'HorizontalAlignment','Left',...
    'Position',[hPos vPos-5 textWidth controlHeight]);
ContourColormap = uicontrol(fh,'Style','popupmenu',...
    'String',Colormaps,...
    'Value', find(strcmp(Colormaps,PIVParams.ContourColormap)),...
    'Position',[hPos+hSpacing vPos controlWidth controlHeight]);
vPos = vPos - vSpacing;
uicontrol(fh,'Style','text',...
    'String','Number of colorsteps:',...
    'HorizontalAlignment','Left',...
    'Position',[hPos vPos-5 textWidth controlHeight]);
ContourSteps = uicontrol(fh,'Style','edit',...
    'String',num2str(PIVParams.ContourSteps),...
    'Position',[hPos+hSpacing vPos controlWidth controlHeight]);
vPos = vPos - vSpacing;
uicontrol(fh,'Style','text',...
    'String','Contour minimum value:',...
    'HorizontalAlignment','Left',...
    'Position',[hPos vPos-5 textWidth controlHeight]);
ScalarMinValue = uicontrol(fh,'Style','edit',...
    'String',num2str(PIVParams.ScalarMinValue),...
    'Position',[hPos+hSpacing vPos controlWidth controlHeight]);
vPos = vPos - vSpacing;
uicontrol(fh,'Style','text',...
    'String','Contour maximum value:',...
    'HorizontalAlignment','Left',...
    'Position',[hPos vPos-5 textWidth controlHeight]);
ScalarMaxValue = uicontrol(fh,'Style','edit',...
    'String',num2str(PIVParams.ScalarMaxValue),...
    'Position',[hPos+hSpacing vPos controlWidth controlHeight]);
vPos = vPos - vSpacing;
ScalarAutoScale = uicontrol(fh,'Style','checkbox',...
    'String','Auto-scale contour',...
    'Value',PIVParams.ScalarAutoScale,...
    'Position',[hPos+10 vPos textWidth controlHeight]);


%%% OK and cancel
uicontrol(fh,'Style','pushbutton',...
    'String','OK',...
    'Position',[30 30 110 30],...
    'Callback',@ApplyCallback);
uicontrol(fh,'Style','pushbutton',...
    'String','Cancel',...
    'Position',[170 30 110 30],...
    'Callback',@CancelCallback);

%%  Initialization tasks

set(fh,'Visible','on')

%%  Callbacks
    function CancelCallback(~,~)
        delete(fh)
    end
    function ApplyCallback(~,~)
        % load the structure
        PIVParams = guidata(main_handle);

        %%% adjust the data
        PIVParams.ShowVectors = get(ShowVectors,'Value');
        Value = get(ColorCodeVectors,'Value');
        if Value==3
            PIVParams.VectorColorValidation = true;
        else
            PIVParams.VectorColorValidation = false;
            PIVParams.ColorCodeVectors = Value-1;
        end
        PIVParams.VectorColormap = char(Colormaps(get(VectorColormap,'Value')));
        value = get(VectorColor,'String');
        if value(1)=='['
            eval(['PIVParams.VectorColor = ' value]);
        else
            PIVParams.VectorColor = value;
        end
        PIVParams.VectorScale = str2double(get(VectorScale,'String'));
        PIVParams.ShowImage = get(ShowImage,'Value');
        PIVParams.ShowGrid = get(ShowGrid,'Value');
        PIVParams.ShowContour = get(ShowContour,'Value');
        PIVParams.ContourScalar = char(ContourScalars(get(ContourScalar,'Value')));
        PIVParams.ContourColormap = char(Colormaps(get(ContourColormap,'Value')));
        PIVParams.ContourSteps = str2double(get(ContourSteps,'String'));
        PIVParams.ScalarMinValue = str2double(get(ScalarMinValue,'String'));
        PIVParams.ScalarMaxValue = str2double(get(ScalarMaxValue,'String'));
        PIVParams.ScalarAutoScale = get(ScalarAutoScale,'Value');
        
        
        %%% save the structure
        guidata(main_handle,PIVParams)
        delete(fh)
    end

%%  Utility functions

end